/**
 * 
 */
package gov.va.genisis2.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.genisis2.dao.IUserManagementDAO;
import gov.va.genisis2.model.Users;
import gov.va.genisis2.service.IUserManagementService;


/**
 * The Class UserManagementService.
 *
 * @author Getaneh Kassahun
 */

/**
 * The Class UserManagementService.
 */
@Service
public class UserManagementService implements IUserManagementService {

	/** The user management DAO. */
	@Autowired
	private IUserManagementDAO userManagementDAO;

	/**
	 * Gets the user management DAO.
	 *
	 * @return the userManagementDAO
	 */
	public IUserManagementDAO getUserManagementDAO() {
		return userManagementDAO;
	}

	/**
	 * Sets the user management DAO.
	 * 
	 * @param userManagementDAO
	 *            the userManagementDAO to set
	 */
	public void setUserManagementDAO(IUserManagementDAO userManagementDAO) {
		this.userManagementDAO = userManagementDAO;
	}

	/**
	 * This method is used to getUserDetailsByEmail.
	 * @param email The email.
	 * @return Users This returns Users.
	 */
	@Override
	public Users getUserDetailsByEmail(String email) {
		return userManagementDAO.getUserDetailsByEmail(email);
	}

	/**
	 * This method is used to getUserDetailsById.
	 * @param id The id.
	 * @return Users This returns users.
	 */
	@Override
	public Users getUserDetailsById(int id) {
		return userManagementDAO.getUserDetailsById(id);
	}

	
	/**
	 * This method is used to getUserRole.
	 * @param uid The uid.
	 * @return String This returns userRole.
	 */
	@Override
	public String getUserRole(int uid) {
		return userManagementDAO.getUserRole(uid);
	}


	/**
	 * This method is used to create User
	 * @param user The user.
	 * @return int This returns userId.
	 */
	@Override
	public int submitOrModifyUser(Users user) {
			return userManagementDAO.submitOrModifyUser(user);
	}

}
